﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Timers;
using InSimDotNet;
using InSimDotNet.Packets;

namespace Dizplay_Cruise.Button
{
    public class Processor
    {
        public static List<clsQueue> QueueHolder = new List<clsQueue>();
        public static Timer QueueProcessor = new Timer();
        public static int maxPerUCID = 4;
        public static object QP_Lock = new object();
        public static string MT_Report = "";

        public static void Start()
        {
            if (QueueProcessor.Enabled != true)
            {
                QueueProcessor.Elapsed += new ElapsedEventHandler(Processor.QueueProcessor_Elapsed);
                QueueProcessor.Interval = 10;
                QueueProcessor.Start();
            }
        }

        public static void QueueProcessor_Elapsed(object source, ElapsedEventArgs e)
        {
            try
            {
                MT_Report += "Attempt to access resource (";
                lock (QP_Lock)
                {
                    int[] UCIDTimes = new int[256];
                    int Count = QueueHolder.Count;
                    int MT_Report_i = 0;

                    for (int i = 0; i < QueueHolder.Count; i++)
                    {
                        if (QueueHolder.Count > 0 && QueueHolder[i] != null && QueueHolder[i].Button != null)
                        {
                            int UCID = QueueHolder[i].Button.ConnectionId;
                            int idx = Dizplay.getUserIdxByUCID(UCID);

                            if (UCIDTimes[UCID] < maxPerUCID)
                            {
                                clsUser U = Dizplay.Users[idx];

                                Dizplay.iSend(QueueHolder[i].Button);
                                U.Buttons[QueueHolder[i].Button.ClickId] = CopyButton(QueueHolder[i].Button);
                                UCIDTimes[UCID] += 1;

                                QueueHolder.RemoveAt(i);
                                i--;

                                MT_Report_i++;
                            }
                        }
                    }
                    MT_Report += MT_Report_i + " out of " + Count;

                    if (QueueHolder.Count < 1)
                    {
                        MT_Report += "; timer stopping)";
                        QueueProcessor.Stop();
                        QueueProcessor.Elapsed -= new ElapsedEventHandler(Processor.QueueProcessor_Elapsed);
                        //QueueProcessor.Dispose();

                        Dizplay_Cruise.Processor.HistoryAdd("Multi-threading report (Button dispatcher)", MT_Report);
                        MT_Report = "";
                        return;
                    }
                }
                MT_Report += ")" + Globals.nl;
            }
            catch (Exception E)
            {
                Dizplay_Cruise.Processor.ErrorRecord(E);
            }
        }

        /// <summary>
        /// Adds a button request to the button queue.
        /// </summary>
        /// <param name="Text">The text of the button.</param>
        /// <param name="ButtonStyles">Button style flags.</param>
        /// <param name="H">The height of the button (0 to 200).</param>
        /// <param name="W">The width of the button (0 to 200).</param>
        /// <param name="T">The distance from the top of the screen the button will be displayed (0 to 200).</param>
        /// <param name="L">The distance from the left of the screen the button will be displayed (0 to 200).</param>
        /// <param name="ClickID">Unique button click ID.</param>
        /// <param name="ReqI">Packet request ID.</param>
        /// <param name="UCID">The connection to display the button (0 = local / 255 = all).</param>
        /// <param name="xAlign">Horizontal button alignment</param>
        /// <param name="yAlign">Vertical button alignment</param>
        /// <param name="TypeIn">The maximum characters the user is allowed to type in.</param>
        /// <param name="Caption">The caption for a type-in button.</param>
        /// <param name="Inst">Used internally by insim. (128 = always on top)</param>
        public static void QueueButton(string Text, ButtonStyles ButtonStyles, byte H, byte W, byte T, byte L, byte ClickID, byte ReqI, int UCID, Globals.xAlign xAlign = Globals.xAlign.left, Globals.yAlign yAlign = Globals.yAlign.top, byte TypeIn = 0, string Caption = "", bool Inst = false)
        {
            if (!Globals.Locked)
            {
                switch (xAlign)
                {
                    case Globals.xAlign.center:
                        L = (byte)((100 - W / 2) + L);
                        break;

                    case Globals.xAlign.right:
                        L = (byte)((200 - W) - L);
                        break;

                }

                switch (yAlign)
                {
                    case Globals.yAlign.middle:
                        T = (byte)((100 - H / 2) + T);
                        break;

                    case Globals.yAlign.bottom:
                        T = (byte)((200 - H) - T);
                        break;
                }

                ButtonPacket B = new ButtonPacket { Styles = ButtonStyles, ClickId = ClickID, Height = H, Width = W, Left = L, Top = T, RequestId = ReqI, Text = Text, TypeIn = TypeIn, Caption = Caption, UseDefaultText = Inst, ConnectionId = UCID };

                clsUser U = Dizplay.Users[Dizplay.getUserIdxByUCID(B.ConnectionId)];
                if (!Processor.ButtonsIdentical(B, U.Buttons[B.ClickId]))
                {
                    clsQueue Queue = new clsQueue();
                    Queue.Button = B;
                    QueueHolder.Add(Queue);
                }
            }
        }

        /// <summary>
        /// Adds a button request to the button queue.
        /// </summary>
        /// <param name="Button">The button (ButtonPacket)</param>
        public static void QueueButton(ButtonPacket B)
        {
            if (!Globals.Locked)
            {
                clsUser U = Dizplay.Users[Dizplay.getUserIdxByUCID(B.ConnectionId)];
                if (!Processor.ButtonsIdentical(B, U.Buttons[B.ClickId]))
                {
                    clsQueue Queue = new clsQueue();
                    Queue.Button = new ButtonPacket { Styles = B.Styles, ClickId = B.ClickId, Height = B.Height, Width = B.Width, Left = B.Left, Top = B.Top, RequestId = B.RequestId, Text = B.Text, TypeIn = B.TypeIn, Caption = B.Caption, UseDefaultText = B.UseDefaultText, ConnectionId = B.ConnectionId };
                    QueueHolder.Add(Queue);
                }
            }
        }

        /// <summary>
        /// Returns a button with the specifications you give.
        /// </summary>
        /// <param name="Text">The text of the button.</param>
        /// <param name="ButtonStyles">Button style flags.</param>
        /// <param name="H">The height of the button (0 to 200).</param>
        /// <param name="W">The width of the button (0 to 200).</param>
        /// <param name="T">The distance from the top of the screen the button will be displayed (0 to 200).</param>
        /// <param name="L">The distance from the left of the screen the button will be displayed (0 to 200).</param>
        /// <param name="ClickID">Unique button click ID.</param>
        /// <param name="ReqI">Packet request ID.</param>
        /// <param name="UCID">The connection to display the button (0 = local / 255 = all).</param>
        /// <param name="xAlign">Horizontal button alignment</param>
        /// <param name="yAlign">Vertical button alignment</param>
        /// <param name="TypeIn">The maximum characters the user is allowed to type in.</param>
        /// <param name="Caption">The caption for a type-in button.</param>
        /// <param name="Inst">Used internally by insim. (128 = always on top)</param>
        public static ButtonPacket ToBTN(string Text, ButtonStyles ButtonStyles, byte H, byte W, byte T, byte L, byte ClickID, byte ReqI, byte UCID, Globals.xAlign xAlign = Globals.xAlign.left, Globals.yAlign yAlign = Globals.yAlign.top, byte TypeIn = 0, string Caption = "", bool Inst = false)
        {
            switch (xAlign)
            {
                case Globals.xAlign.center:
                    L = (byte)((100 - W / 2) + L);
                    break;

                case Globals.xAlign.right:
                    L = (byte)((200 - W) - L);
                    break;

            }

            switch (yAlign)
            {
                case Globals.yAlign.middle:
                    T = (byte)((100 - H / 2) + T);
                    break;

                case Globals.yAlign.bottom:
                    T = (byte)((200 - H) - T);
                    break;
            }

            return new ButtonPacket { Styles = ButtonStyles, ClickId = ClickID, Height = H, Width = W, Left = L, Top = T, RequestId = ReqI, Text = Text, TypeIn = TypeIn, Caption = Caption, UseDefaultText = Inst, ConnectionId = UCID };
        }


        /// <summary>
        /// Copies a button, and returns the copy back.
        /// </summary>
        /// <param name="Text">The text of the button.</param>
        /// <param name="ButtonStyles">Button style flags.</param>
        /// <param name="H">The height of the button (0 to 200).</param>
        /// <param name="W">The width of the button (0 to 200).</param>
        /// <param name="T">The distance from the top of the screen the button will be displayed (0 to 200).</param>
        /// <param name="L">The distance from the left of the screen the button will be displayed (0 to 200).</param>
        /// <param name="ClickID">Unique button click ID.</param>
        /// <param name="ReqI">Packet request ID.</param>
        /// <param name="UCID">The connection to display the button (0 = local / 255 = all).</param>
        /// <param name="xAlign">Horizontal button alignment</param>
        /// <param name="yAlign">Vertical button alignment</param>
        /// <param name="TypeIn">The maximum characters the user is allowed to type in.</param>
        /// <param name="Caption">The caption for a type-in button.</param>
        /// <param name="Inst">Used internally by insim. (128 = always on top)</param>
        public static ButtonPacket CopyButton(ButtonPacket B, Globals.xAlign xAlign = Globals.xAlign.left, Globals.yAlign yAlign = Globals.yAlign.top)
        {
            int T = B.Top;
            int L = B.Left;

            switch (xAlign)
            {
                case Globals.xAlign.center:
                    L = (int)((100 - B.Width / 2) + B.Left);
                    break;

                case Globals.xAlign.right:
                    L = (int)((200 - B.Width) - B.Left);
                    break;

            }

            switch (yAlign)
            {
                case Globals.yAlign.middle:
                    T = (int)((100 - B.Height / 2) + B.Top);
                    break;

                case Globals.yAlign.bottom:
                    T = (int)((200 - B.Height) - B.Top);
                    break;
            }

            return new ButtonPacket { Styles = B.Styles, ClickId = B.ClickId, Height = B.Height, Width = B.Width, Left = L, Top = T, RequestId = B.RequestId, Text = B.Text, TypeIn = B.TypeIn, Caption = B.Caption, UseDefaultText = B.UseDefaultText, ConnectionId = B.ConnectionId };
        }

        /// <summary>
        /// Checks if the 2 buttons provided are identical. Returns true if they are, and false if they are not.
        /// </summary>
        /// <param name="Button1">ButtonPacket Type</param>
        /// <param name="Button2">ButtonPacket Type</param>
        /// <returns></returns>
        public static bool ButtonsIdentical(ButtonPacket Button1, ButtonPacket Button2)
        {
            if ((Button1 == null || Button2 == null) && (Button1 != null || Button2 != null))
            {
                return false;
            }
            if (Button1.Styles != Button2.Styles)
            {
                return false;
            }
            if (Button1.Caption != Button2.Caption)
            {
                return false;
            }
            if (Button1.ClickId != Button2.ClickId)
            {
                return false;
            }
            if (Button1.Height != Button2.Height)
            {
                return false;
            }
            if (Button1.UseDefaultText != Button2.UseDefaultText)
            {
                return false;
            }
            if (Button1.Left != Button2.Left)
            {
                return false;
            }
            if (Button1.RequestId != Button2.RequestId)
            {
                return false;
            }
            if (Button1.Top != Button2.Top)
            {
                return false;
            }
            if (Button1.Text != Button2.Text)
            {
                return false;
            }
            if (Button1.TypeIn != Button2.TypeIn)
            {
                return false;
            }
            if (Button1.Width != Button2.Width)
            {
                return false;
            }

            return true;
        }
    }
}
